package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthorizationRule(
    clientVpnEndpointId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    groupId: Optional[String] = Optional.Absent,
    accessAll: Optional[Boolean] = Optional.Absent,
    destinationCidr: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizationRule = {
    import AuthorizationRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizationRule
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(accessAll.map(value => value: java.lang.Boolean))(
        _.accessAll
      )
      .optionallyWith(destinationCidr.map(value => value: java.lang.String))(
        _.destinationCidr
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AuthorizationRule.ReadOnly =
    zio.aws.ec2.model.AuthorizationRule.wrap(buildAwsValue())
}
object AuthorizationRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizationRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizationRule =
      zio.aws.ec2.model.AuthorizationRule(
        clientVpnEndpointId.map(value => value),
        description.map(value => value),
        groupId.map(value => value),
        accessAll.map(value => value),
        destinationCidr.map(value => value),
        status.map(value => value.asEditable)
      )
    def clientVpnEndpointId: Optional[String]
    def description: Optional[String]
    def groupId: Optional[String]
    def accessAll: Optional[Boolean]
    def destinationCidr: Optional[String]
    def status
        : Optional[zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getAccessAll: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("accessAll", accessAll)
    def getDestinationCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidr", destinationCidr)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizationRule
  ) extends zio.aws.ec2.model.AuthorizationRule.ReadOnly {
    override val clientVpnEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpnEndpointId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val accessAll: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.accessAll())
      .map(value => value: Boolean)
    override val destinationCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidr())
      .map(value => value: String)
    override val status: Optional[
      zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.ec2.model.ClientVpnAuthorizationRuleStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizationRule
  ): zio.aws.ec2.model.AuthorizationRule.ReadOnly = new Wrapper(impl)
}
