package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AssociationStatusCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.AssociationStatusCode
}
object AssociationStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AssociationStatusCode
  ): zio.aws.ec2.model.AssociationStatusCode = value match {
    case software.amazon.awssdk.services.ec2.model.AssociationStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AssociationStatusCode.ASSOCIATING =>
      val r = associating
      r
    case software.amazon.awssdk.services.ec2.model.AssociationStatusCode.ASSOCIATED =>
      val r = associated
      r
    case software.amazon.awssdk.services.ec2.model.AssociationStatusCode.ASSOCIATION_FAILED =>
      val r = `association-failed`
      r
    case software.amazon.awssdk.services.ec2.model.AssociationStatusCode.DISASSOCIATING =>
      val r = disassociating
      r
    case software.amazon.awssdk.services.ec2.model.AssociationStatusCode.DISASSOCIATED =>
      val r = disassociated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AssociationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociationStatusCode =
      software.amazon.awssdk.services.ec2.model.AssociationStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object associating extends zio.aws.ec2.model.AssociationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociationStatusCode =
      software.amazon.awssdk.services.ec2.model.AssociationStatusCode.ASSOCIATING
  }
  case object associated extends zio.aws.ec2.model.AssociationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociationStatusCode =
      software.amazon.awssdk.services.ec2.model.AssociationStatusCode.ASSOCIATED
  }
  case object `association-failed`
      extends zio.aws.ec2.model.AssociationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociationStatusCode =
      software.amazon.awssdk.services.ec2.model.AssociationStatusCode.ASSOCIATION_FAILED
  }
  case object disassociating extends zio.aws.ec2.model.AssociationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociationStatusCode =
      software.amazon.awssdk.services.ec2.model.AssociationStatusCode.DISASSOCIATING
  }
  case object disassociated extends zio.aws.ec2.model.AssociationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AssociationStatusCode =
      software.amazon.awssdk.services.ec2.model.AssociationStatusCode.DISASSOCIATED
  }
}
