package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, DefaultingDhcpOptionsId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateDhcpOptionsRequest(
    dhcpOptionsId: DefaultingDhcpOptionsId,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest = {
    import AssociateDhcpOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
      .builder()
      .dhcpOptionsId(
        DefaultingDhcpOptionsId.unwrap(dhcpOptionsId): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateDhcpOptionsRequest.ReadOnly =
    zio.aws.ec2.model.AssociateDhcpOptionsRequest.wrap(buildAwsValue())
}
object AssociateDhcpOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateDhcpOptionsRequest =
      zio.aws.ec2.model.AssociateDhcpOptionsRequest(dhcpOptionsId, vpcId)
    def dhcpOptionsId: DefaultingDhcpOptionsId
    def vpcId: VpcId
    def getDhcpOptionsId: ZIO[Any, Nothing, DefaultingDhcpOptionsId] =
      ZIO.succeed(dhcpOptionsId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
  ) extends zio.aws.ec2.model.AssociateDhcpOptionsRequest.ReadOnly {
    override val dhcpOptionsId: DefaultingDhcpOptionsId =
      zio.aws.ec2.model.primitives.DefaultingDhcpOptionsId(impl.dhcpOptionsId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest
  ): zio.aws.ec2.model.AssociateDhcpOptionsRequest.ReadOnly = new Wrapper(impl)
}
