package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Port, IpAddress}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AnalysisLoadBalancerTarget(
    address: Optional[IpAddress] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    instance: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    port: Optional[Port] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget = {
    import AnalysisLoadBalancerTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
      .builder()
      .optionallyWith(
        address.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(instance.map(value => value.buildAwsValue()))(_.instance)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly =
    zio.aws.ec2.model.AnalysisLoadBalancerTarget.wrap(buildAwsValue())
}
object AnalysisLoadBalancerTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisLoadBalancerTarget =
      zio.aws.ec2.model.AnalysisLoadBalancerTarget(
        address.map(value => value),
        availabilityZone.map(value => value),
        instance.map(value => value.asEditable),
        port.map(value => value)
      )
    def address: Optional[IpAddress]
    def availabilityZone: Optional[String]
    def instance: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def port: Optional[Port]
    def getAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("address", address)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstance
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("instance", instance)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
  ) extends zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly {
    override val address: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val instance
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instance())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisLoadBalancerTarget
  ): zio.aws.ec2.model.AnalysisLoadBalancerTarget.ReadOnly = new Wrapper(impl)
}
