package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountAttributeValue(
    attributeValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AccountAttributeValue = {
    import AccountAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AccountAttributeValue
      .builder()
      .optionallyWith(attributeValue.map(value => value: java.lang.String))(
        _.attributeValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AccountAttributeValue.ReadOnly =
    zio.aws.ec2.model.AccountAttributeValue.wrap(buildAwsValue())
}
object AccountAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AccountAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AccountAttributeValue = zio.aws.ec2.model
      .AccountAttributeValue(attributeValue.map(value => value))
    def attributeValue: Optional[String]
    def getAttributeValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AccountAttributeValue
  ) extends zio.aws.ec2.model.AccountAttributeValue.ReadOnly {
    override val attributeValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AccountAttributeValue
  ): zio.aws.ec2.model.AccountAttributeValue.ReadOnly = new Wrapper(impl)
}
