package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInsightsAccessScopeId,
  NetworkInsightsAccessScopeAnalysisId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccessScopeAnalysisFinding(
    networkInsightsAccessScopeAnalysisId: Optional[
      NetworkInsightsAccessScopeAnalysisId
    ] = Optional.Absent,
    networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId] =
      Optional.Absent,
    findingId: Optional[String] = Optional.Absent,
    findingComponents: Optional[Iterable[zio.aws.ec2.model.PathComponent]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding = {
    import AccessScopeAnalysisFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysisId.map(value =>
          NetworkInsightsAccessScopeAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeAnalysisId)
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(findingId.map(value => value: java.lang.String))(
        _.findingId
      )
      .optionallyWith(
        findingComponents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingComponents)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly =
    zio.aws.ec2.model.AccessScopeAnalysisFinding.wrap(buildAwsValue())
}
object AccessScopeAnalysisFinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AccessScopeAnalysisFinding =
      zio.aws.ec2.model.AccessScopeAnalysisFinding(
        networkInsightsAccessScopeAnalysisId.map(value => value),
        networkInsightsAccessScopeId.map(value => value),
        findingId.map(value => value),
        findingComponents.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId]
    def networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    def findingId: Optional[String]
    def findingComponents
        : Optional[List[zio.aws.ec2.model.PathComponent.ReadOnly]]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeAnalysisId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeAnalysisId",
        networkInsightsAccessScopeAnalysisId
      )
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getFindingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("findingId", findingId)
    def getFindingComponents
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      AwsError.unwrapOptionField("findingComponents", findingComponents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding
  ) extends zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeAnalysisId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(value)
      )
    override val networkInsightsAccessScopeId
        : Optional[NetworkInsightsAccessScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val findingId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.findingId())
      .map(value => value: String)
    override val findingComponents
        : Optional[List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingComponents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PathComponent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AccessScopeAnalysisFinding
  ): zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly = new Wrapper(impl)
}
