package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptTransitGatewayPeeringAttachmentResponse(
    transitGatewayPeeringAttachment: Optional[
      zio.aws.ec2.model.TransitGatewayPeeringAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse = {
    import AcceptTransitGatewayPeeringAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayPeeringAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayPeeringAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly =
    zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse
      .wrap(buildAwsValue())
}
object AcceptTransitGatewayPeeringAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse =
      zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse(
        transitGatewayPeeringAttachment.map(value => value.asEditable)
      )
    def transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly]
    def getTransitGatewayPeeringAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPeeringAttachment",
      transitGatewayPeeringAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse
  ) extends zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly {
    override val transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayPeeringAttachment())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse
  ): zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
