package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPrefixListReference(
    transitGatewayRouteTableId: Optional[TransitGatewayRouteTableId] =
      Optional.Absent,
    prefixListId: Optional[PrefixListResourceId] = Optional.Absent,
    prefixListOwnerId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayPrefixListReferenceState] =
      Optional.Absent,
    blackhole: Optional[Boolean] = Optional.Absent,
    transitGatewayAttachment: Optional[
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference = {
    import TransitGatewayPrefixListReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
      .builder()
      .optionallyWith(
        transitGatewayRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableId)
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(prefixListOwnerId.map(value => value: java.lang.String))(
        _.prefixListOwnerId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(blackhole.map(value => value: java.lang.Boolean))(
        _.blackhole
      )
      .optionallyWith(
        transitGatewayAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayAttachment)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPrefixListReference.wrap(buildAwsValue())
}
object TransitGatewayPrefixListReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPrefixListReference =
      zio.aws.ec2.model.TransitGatewayPrefixListReference(
        transitGatewayRouteTableId.map(value => value),
        prefixListId.map(value => value),
        prefixListOwnerId.map(value => value),
        state.map(value => value),
        blackhole.map(value => value),
        transitGatewayAttachment.map(value => value.asEditable)
      )
    def transitGatewayRouteTableId: Optional[TransitGatewayRouteTableId]
    def prefixListId: Optional[PrefixListResourceId]
    def prefixListOwnerId: Optional[String]
    def state
        : Optional[zio.aws.ec2.model.TransitGatewayPrefixListReferenceState]
    def blackhole: Optional[Boolean]
    def transitGatewayAttachment: Optional[
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly
    ]
    def getTransitGatewayRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getPrefixListOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListOwnerId", prefixListOwnerId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPrefixListReferenceState
    ] = AwsError.unwrapOptionField("state", state)
    def getBlackhole: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blackhole", blackhole)
    def getTransitGatewayAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayAttachment",
      transitGatewayAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
  ) extends zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly {
    override val transitGatewayRouteTableId
        : Optional[TransitGatewayRouteTableId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
    override val prefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val prefixListOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListOwnerId())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayPrefixListReferenceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPrefixListReferenceState.wrap(value)
        )
    override val blackhole: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blackhole())
      .map(value => value: Boolean)
    override val transitGatewayAttachment: Optional[
      zio.aws.ec2.model.TransitGatewayPrefixListAttachment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachment())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPrefixListAttachment.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPrefixListReference
  ): zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly = new Wrapper(
    impl
  )
}
