package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SnapshotState {
  def unwrap: software.amazon.awssdk.services.ec2.model.SnapshotState
}
object SnapshotState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SnapshotState
  ): zio.aws.ec2.model.SnapshotState = value match {
    case software.amazon.awssdk.services.ec2.model.SnapshotState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SnapshotState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.SnapshotState.COMPLETED =>
      val r = completed
      r
    case software.amazon.awssdk.services.ec2.model.SnapshotState.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.ec2.model.SnapshotState.RECOVERABLE =>
      val r = recoverable
      r
    case software.amazon.awssdk.services.ec2.model.SnapshotState.RECOVERING =>
      val r = recovering
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotState =
      software.amazon.awssdk.services.ec2.model.SnapshotState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.SnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotState =
      software.amazon.awssdk.services.ec2.model.SnapshotState.PENDING
  }
  case object completed extends zio.aws.ec2.model.SnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotState =
      software.amazon.awssdk.services.ec2.model.SnapshotState.COMPLETED
  }
  case object error extends zio.aws.ec2.model.SnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotState =
      software.amazon.awssdk.services.ec2.model.SnapshotState.ERROR
  }
  case object recoverable extends zio.aws.ec2.model.SnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotState =
      software.amazon.awssdk.services.ec2.model.SnapshotState.RECOVERABLE
  }
  case object recovering extends zio.aws.ec2.model.SnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SnapshotState =
      software.amazon.awssdk.services.ec2.model.SnapshotState.RECOVERING
  }
}
