package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RejectTransitGatewayVpcAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest = {
    import RejectTransitGatewayVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object RejectTransitGatewayVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest =
      zio.aws.ec2.model
        .RejectTransitGatewayVpcAttachmentRequest(transitGatewayAttachmentId)
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest
  ) extends zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest
  ): zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
