package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class ProvisionedBandwidth(
    provisionTime: Optional[DateTime] = Optional.Absent,
    provisioned: Optional[String] = Optional.Absent,
    requestTime: Optional[DateTime] = Optional.Absent,
    requested: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth = {
    import ProvisionedBandwidth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
      .builder()
      .optionallyWith(
        provisionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.provisionTime)
      .optionallyWith(provisioned.map(value => value: java.lang.String))(
        _.provisioned
      )
      .optionallyWith(
        requestTime.map(value => DateTime.unwrap(value): Instant)
      )(_.requestTime)
      .optionallyWith(requested.map(value => value: java.lang.String))(
        _.requested
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly =
    zio.aws.ec2.model.ProvisionedBandwidth.wrap(buildAwsValue())
}
object ProvisionedBandwidth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionedBandwidth =
      zio.aws.ec2.model.ProvisionedBandwidth(
        provisionTime.map(value => value),
        provisioned.map(value => value),
        requestTime.map(value => value),
        requested.map(value => value),
        status.map(value => value)
      )
    def provisionTime: Optional[DateTime]
    def provisioned: Optional[String]
    def requestTime: Optional[DateTime]
    def requested: Optional[String]
    def status: Optional[String]
    def getProvisionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("provisionTime", provisionTime)
    def getProvisioned: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provisioned", provisioned)
    def getRequestTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getRequested: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requested", requested)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
  ) extends zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly {
    override val provisionTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val provisioned: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioned())
      .map(value => value: String)
    override val requestTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.requestTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val requested: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requested())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth
  ): zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly = new Wrapper(impl)
}
