package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PriceSchedule(
    active: Optional[Boolean] = Optional.Absent,
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    price: Optional[Double] = Optional.Absent,
    term: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PriceSchedule = {
    import PriceSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PriceSchedule
      .builder()
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(price.map(value => value: java.lang.Double))(_.price)
      .optionallyWith(term.map(value => value: java.lang.Long))(_.term)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PriceSchedule.ReadOnly =
    zio.aws.ec2.model.PriceSchedule.wrap(buildAwsValue())
}
object PriceSchedule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PriceSchedule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PriceSchedule =
      zio.aws.ec2.model.PriceSchedule(
        active.map(value => value),
        currencyCode.map(value => value),
        price.map(value => value),
        term.map(value => value)
      )
    def active: Optional[Boolean]
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def price: Optional[Double]
    def term: Optional[Long]
    def getActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("active", active)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("price", price)
    def getTerm: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("term", term)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PriceSchedule
  ) extends zio.aws.ec2.model.PriceSchedule.ReadOnly {
    override val active: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: Boolean)
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val price: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.price())
      .map(value => value: Double)
    override val term: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.term())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PriceSchedule
  ): zio.aws.ec2.model.PriceSchedule.ReadOnly = new Wrapper(impl)
}
