package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorFilterRuleResponse(
    trafficMirrorFilterRule: Optional[
      zio.aws.ec2.model.TrafficMirrorFilterRule
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse = {
    import ModifyTrafficMirrorFilterRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse
      .builder()
      .optionallyWith(
        trafficMirrorFilterRule.map(value => value.buildAwsValue())
      )(_.trafficMirrorFilterRule)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse
      .wrap(buildAwsValue())
}
object ModifyTrafficMirrorFilterRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse =
      zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse(
        trafficMirrorFilterRule.map(value => value.asEditable)
      )
    def trafficMirrorFilterRule
        : Optional[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]
    def getTrafficMirrorFilterRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly
    ] = AwsError.unwrapOptionField(
      "trafficMirrorFilterRule",
      trafficMirrorFilterRule
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly {
    override val trafficMirrorFilterRule
        : Optional[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorFilterRule())
        .map(value => zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse
  ): zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly =
    new Wrapper(impl)
}
