package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorFilterNetworkServicesResponse(
    trafficMirrorFilter: Optional[zio.aws.ec2.model.TrafficMirrorFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse = {
    import ModifyTrafficMirrorFilterNetworkServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse
      .builder()
      .optionallyWith(trafficMirrorFilter.map(value => value.buildAwsValue()))(
        _.trafficMirrorFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse
      .wrap(buildAwsValue())
}
object ModifyTrafficMirrorFilterNetworkServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse =
      zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse(
        trafficMirrorFilter.map(value => value.asEditable)
      )
    def trafficMirrorFilter
        : Optional[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly]
    def getTrafficMirrorFilter
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorFilter", trafficMirrorFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly {
    override val trafficMirrorFilter
        : Optional[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorFilter())
        .map(value => zio.aws.ec2.model.TrafficMirrorFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse
  ): zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly =
    new Wrapper(impl)
}
