package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamPoolCidr(
    cidr: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.IpamPoolCidrState] = Optional.Absent,
    failureReason: Optional[zio.aws.ec2.model.IpamPoolCidrFailureReason] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamPoolCidr = {
    import IpamPoolCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamPoolCidr
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(failureReason.map(value => value.buildAwsValue()))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamPoolCidr.ReadOnly =
    zio.aws.ec2.model.IpamPoolCidr.wrap(buildAwsValue())
}
object IpamPoolCidr {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpamPoolCidr] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamPoolCidr =
      zio.aws.ec2.model.IpamPoolCidr(
        cidr.map(value => value),
        state.map(value => value),
        failureReason.map(value => value.asEditable)
      )
    def cidr: Optional[String]
    def state: Optional[zio.aws.ec2.model.IpamPoolCidrState]
    def failureReason
        : Optional[zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolCidrState] =
      AwsError.unwrapOptionField("state", state)
    def getFailureReason: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly
    ] = AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolCidr
  ) extends zio.aws.ec2.model.IpamPoolCidr.ReadOnly {
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.IpamPoolCidrState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.IpamPoolCidrState.wrap(value))
    override val failureReason
        : Optional[zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value => zio.aws.ec2.model.IpamPoolCidrFailureReason.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolCidr
  ): zio.aws.ec2.model.IpamPoolCidr.ReadOnly = new Wrapper(impl)
}
