package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceTypeInfoFromInstanceRequirements(
    instanceType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceTypeInfoFromInstanceRequirements = {
    import InstanceTypeInfoFromInstanceRequirements.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceTypeInfoFromInstanceRequirements
      .builder()
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly =
    zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements
      .wrap(buildAwsValue())
}
object InstanceTypeInfoFromInstanceRequirements {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceTypeInfoFromInstanceRequirements
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements =
      zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements(
        instanceType.map(value => value)
      )
    def instanceType: Optional[String]
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeInfoFromInstanceRequirements
  ) extends zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly {
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeInfoFromInstanceRequirements
  ): zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly =
    new Wrapper(impl)
}
