package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceNetworkInterfaceAssociation(
    carrierIp: Optional[String] = Optional.Absent,
    customerOwnedIp: Optional[String] = Optional.Absent,
    ipOwnerId: Optional[String] = Optional.Absent,
    publicDnsName: Optional[String] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation = {
    import InstanceNetworkInterfaceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
      .builder()
      .optionallyWith(carrierIp.map(value => value: java.lang.String))(
        _.carrierIp
      )
      .optionallyWith(customerOwnedIp.map(value => value: java.lang.String))(
        _.customerOwnedIp
      )
      .optionallyWith(ipOwnerId.map(value => value: java.lang.String))(
        _.ipOwnerId
      )
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly =
    zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.wrap(buildAwsValue())
}
object InstanceNetworkInterfaceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceNetworkInterfaceAssociation =
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation(
        carrierIp.map(value => value),
        customerOwnedIp.map(value => value),
        ipOwnerId.map(value => value),
        publicDnsName.map(value => value),
        publicIp.map(value => value)
      )
    def carrierIp: Optional[String]
    def customerOwnedIp: Optional[String]
    def ipOwnerId: Optional[String]
    def publicDnsName: Optional[String]
    def publicIp: Optional[String]
    def getCarrierIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrierIp", carrierIp)
    def getCustomerOwnedIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIp", customerOwnedIp)
    def getIpOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipOwnerId", ipOwnerId)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
  ) extends zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly {
    override val carrierIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.carrierIp())
      .map(value => value: String)
    override val customerOwnedIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerOwnedIp())
      .map(value => value: String)
    override val ipOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipOwnerId())
      .map(value => value: String)
    override val publicDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicDnsName())
      .map(value => value: String)
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation
  ): zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly =
    new Wrapper(impl)
}
