package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DedicatedHostId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceEventWindowAssociationTarget(
    instanceIds: Optional[Iterable[InstanceId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    dedicatedHostIds: Optional[Iterable[DedicatedHostId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationTarget = {
    import InstanceEventWindowAssociationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationTarget
      .builder()
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dedicatedHostIds.map(value =>
          value.map { item =>
            DedicatedHostId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dedicatedHostIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindowAssociationTarget.wrap(buildAwsValue())
}
object InstanceEventWindowAssociationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindowAssociationTarget =
      zio.aws.ec2.model.InstanceEventWindowAssociationTarget(
        instanceIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dedicatedHostIds.map(value => value)
      )
    def instanceIds: Optional[List[InstanceId]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def dedicatedHostIds: Optional[List[DedicatedHostId]]
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDedicatedHostIds: ZIO[Any, AwsError, List[DedicatedHostId]] =
      AwsError.unwrapOptionField("dedicatedHostIds", dedicatedHostIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationTarget
  ) extends zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly {
    override val instanceIds: Optional[List[InstanceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val dedicatedHostIds: Optional[List[DedicatedHostId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedHostIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.DedicatedHostId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationTarget
  ): zio.aws.ec2.model.InstanceEventWindowAssociationTarget.ReadOnly =
    new Wrapper(impl)
}
