package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EbsNvmeSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.EbsNvmeSupport
}
object EbsNvmeSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EbsNvmeSupport
  ): zio.aws.ec2.model.EbsNvmeSupport = value match {
    case software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.SUPPORTED =>
      val r = supported
      r
    case software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.EbsNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported extends zio.aws.ec2.model.EbsNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.UNSUPPORTED
  }
  case object supported extends zio.aws.ec2.model.EbsNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.SUPPORTED
  }
  case object required extends zio.aws.ec2.model.EbsNvmeSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsNvmeSupport =
      software.amazon.awssdk.services.ec2.model.EbsNvmeSupport.REQUIRED
  }
}
