package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayPolicyTableResponse(
    association: Optional[
      zio.aws.ec2.model.TransitGatewayPolicyTableAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse = {
    import DisassociateTransitGatewayPolicyTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableResponse
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayPolicyTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableResponse =
      zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableResponse(
        association.map(value => value.asEditable)
      )
    def association: Optional[
      zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly
    ]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse
  ) extends zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableResponse.ReadOnly {
    override val association: Optional[
      zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.association())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse
  ): zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableResponse.ReadOnly =
    new Wrapper(impl)
}
