package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateEnclaveCertificateIamRoleResponse(
    returnValue: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse = {
    import DisassociateEnclaveCertificateIamRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse
      .wrap(buildAwsValue())
}
object DisassociateEnclaveCertificateIamRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse =
      zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse(
        returnValue.map(value => value)
      )
    def returnValue: Optional[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse
  ) extends zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse
  ): zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly =
    new Wrapper(impl)
}
