package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DestinationFileFormat {
  def unwrap: software.amazon.awssdk.services.ec2.model.DestinationFileFormat
}
object DestinationFileFormat {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DestinationFileFormat
  ): zio.aws.ec2.model.DestinationFileFormat = value match {
    case software.amazon.awssdk.services.ec2.model.DestinationFileFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DestinationFileFormat.PLAIN_TEXT =>
      val r = `plain-text`
      r
    case software.amazon.awssdk.services.ec2.model.DestinationFileFormat.PARQUET =>
      val r = parquet
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DestinationFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DestinationFileFormat =
      software.amazon.awssdk.services.ec2.model.DestinationFileFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object `plain-text` extends zio.aws.ec2.model.DestinationFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DestinationFileFormat =
      software.amazon.awssdk.services.ec2.model.DestinationFileFormat.PLAIN_TEXT
  }
  case object parquet extends zio.aws.ec2.model.DestinationFileFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DestinationFileFormat =
      software.amazon.awssdk.services.ec2.model.DestinationFileFormat.PARQUET
  }
}
