package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import scala.jdk.CollectionConverters._
final case class DescribeSpotPriceHistoryRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent,
    instanceTypes: Optional[Iterable[zio.aws.ec2.model.InstanceType]] =
      Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    productDescriptions: Optional[Iterable[String]] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest = {
    import DescribeSpotPriceHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceTypesWithStrings)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        productDescriptions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productDescriptions)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.wrap(buildAwsValue())
}
object DescribeSpotPriceHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest =
      zio.aws.ec2.model.DescribeSpotPriceHistoryRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        endTime.map(value => value),
        instanceTypes.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        productDescriptions.map(value => value),
        startTime.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def availabilityZone: Optional[String]
    def endTime: Optional[DateTime]
    def instanceTypes: Optional[List[zio.aws.ec2.model.InstanceType]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def productDescriptions: Optional[List[String]]
    def startTime: Optional[DateTime]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getInstanceTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProductDescriptions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("productDescriptions", productDescriptions)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
  ) extends zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instanceTypes: Optional[List[zio.aws.ec2.model.InstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceType.wrap(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val productDescriptions: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescriptions())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
  ): zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
