package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse(
    localGatewayRouteTableVirtualInterfaceGroupAssociations: Optional[Iterable[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    ]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse = {
    import DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTableVirtualInterfaceGroupAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localGatewayRouteTableVirtualInterfaceGroupAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse =
      zio.aws.ec2.model
        .DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse(
          localGatewayRouteTableVirtualInterfaceGroupAssociations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def localGatewayRouteTableVirtualInterfaceGroupAssociations: Optional[List[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getLocalGatewayRouteTableVirtualInterfaceGroupAssociations: ZIO[
      Any,
      AwsError,
      List[
        zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
      ]
    ] = AwsError.unwrapOptionField(
      "localGatewayRouteTableVirtualInterfaceGroupAssociations",
      localGatewayRouteTableVirtualInterfaceGroupAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse
  ) extends zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly {
    override val localGatewayRouteTableVirtualInterfaceGroupAssociations
        : Optional[List[
          zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
        ]] = zio.aws.core.internal
      .optionalFromNullable(
        impl.localGatewayRouteTableVirtualInterfaceGroupAssociations()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse
  ): zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
