package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSubnetCidrReservationResponse(
    deletedSubnetCidrReservation: Optional[
      zio.aws.ec2.model.SubnetCidrReservation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse = {
    import DeleteSubnetCidrReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse
      .builder()
      .optionallyWith(
        deletedSubnetCidrReservation.map(value => value.buildAwsValue())
      )(_.deletedSubnetCidrReservation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly =
    zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.wrap(buildAwsValue())
}
object DeleteSubnetCidrReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSubnetCidrReservationResponse =
      zio.aws.ec2.model.DeleteSubnetCidrReservationResponse(
        deletedSubnetCidrReservation.map(value => value.asEditable)
      )
    def deletedSubnetCidrReservation
        : Optional[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly]
    def getDeletedSubnetCidrReservation
        : ZIO[Any, AwsError, zio.aws.ec2.model.SubnetCidrReservation.ReadOnly] =
      AwsError.unwrapOptionField(
        "deletedSubnetCidrReservation",
        deletedSubnetCidrReservation
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse
  ) extends zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly {
    override val deletedSubnetCidrReservation
        : Optional[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletedSubnetCidrReservation())
        .map(value => zio.aws.ec2.model.SubnetCidrReservation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse
  ): zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly =
    new Wrapper(impl)
}
