package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteClientVpnRouteResponse(
    status: Optional[zio.aws.ec2.model.ClientVpnRouteStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse = {
    import DeleteClientVpnRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly =
    zio.aws.ec2.model.DeleteClientVpnRouteResponse.wrap(buildAwsValue())
}
object DeleteClientVpnRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteClientVpnRouteResponse =
      zio.aws.ec2.model
        .DeleteClientVpnRouteResponse(status.map(value => value.asEditable))
    def status: Optional[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse
  ) extends zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly {
    override val status
        : Optional[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.ClientVpnRouteStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse
  ): zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly = new Wrapper(impl)
}
