package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCarrierGatewayResponse(
    carrierGateway: Optional[zio.aws.ec2.model.CarrierGateway] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse = {
    import DeleteCarrierGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse
      .builder()
      .optionallyWith(carrierGateway.map(value => value.buildAwsValue()))(
        _.carrierGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly =
    zio.aws.ec2.model.DeleteCarrierGatewayResponse.wrap(buildAwsValue())
}
object DeleteCarrierGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCarrierGatewayResponse =
      zio.aws.ec2.model.DeleteCarrierGatewayResponse(
        carrierGateway.map(value => value.asEditable)
      )
    def carrierGateway: Optional[zio.aws.ec2.model.CarrierGateway.ReadOnly]
    def getCarrierGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.CarrierGateway.ReadOnly] =
      AwsError.unwrapOptionField("carrierGateway", carrierGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse
  ) extends zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly {
    override val carrierGateway
        : Optional[zio.aws.ec2.model.CarrierGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.carrierGateway())
        .map(value => zio.aws.ec2.model.CarrierGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse
  ): zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly = new Wrapper(impl)
}
