package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteTableResponse(
    localGatewayRouteTable: Optional[zio.aws.ec2.model.LocalGatewayRouteTable] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse = {
    import CreateLocalGatewayRouteTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTable.map(value => value.buildAwsValue())
      )(_.localGatewayRouteTable)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLocalGatewayRouteTableResponse.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteTableResponse.wrap(buildAwsValue())
}
object CreateLocalGatewayRouteTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLocalGatewayRouteTableResponse =
      zio.aws.ec2.model.CreateLocalGatewayRouteTableResponse(
        localGatewayRouteTable.map(value => value.asEditable)
      )
    def localGatewayRouteTable
        : Optional[zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly]
    def getLocalGatewayRouteTable: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly
    ] = AwsError.unwrapOptionField(
      "localGatewayRouteTable",
      localGatewayRouteTable
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteTableResponse.ReadOnly {
    override val localGatewayRouteTable
        : Optional[zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTable())
        .map(value => zio.aws.ec2.model.LocalGatewayRouteTable.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse
  ): zio.aws.ec2.model.CreateLocalGatewayRouteTableResponse.ReadOnly =
    new Wrapper(impl)
}
