package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomerGatewayResponse(
    customerGateway: Optional[zio.aws.ec2.model.CustomerGateway] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse = {
    import CreateCustomerGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse
      .builder()
      .optionallyWith(customerGateway.map(value => value.buildAwsValue()))(
        _.customerGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly =
    zio.aws.ec2.model.CreateCustomerGatewayResponse.wrap(buildAwsValue())
}
object CreateCustomerGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCustomerGatewayResponse =
      zio.aws.ec2.model.CreateCustomerGatewayResponse(
        customerGateway.map(value => value.asEditable)
      )
    def customerGateway: Optional[zio.aws.ec2.model.CustomerGateway.ReadOnly]
    def getCustomerGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.CustomerGateway.ReadOnly] =
      AwsError.unwrapOptionField("customerGateway", customerGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse
  ) extends zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly {
    override val customerGateway
        : Optional[zio.aws.ec2.model.CustomerGateway.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerGateway())
        .map(value => zio.aws.ec2.model.CustomerGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse
  ): zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly = new Wrapper(
    impl
  )
}
