package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CapacityReservationState {
  def unwrap: software.amazon.awssdk.services.ec2.model.CapacityReservationState
}
object CapacityReservationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CapacityReservationState
  ): zio.aws.ec2.model.CapacityReservationState = value match {
    case software.amazon.awssdk.services.ec2.model.CapacityReservationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationState.EXPIRED =>
      val r = expired
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationState.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CapacityReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationState.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.ec2.model.CapacityReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationState.ACTIVE
  }
  case object expired extends zio.aws.ec2.model.CapacityReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationState.EXPIRED
  }
  case object cancelled extends zio.aws.ec2.model.CapacityReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationState.CANCELLED
  }
  case object pending extends zio.aws.ec2.model.CapacityReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationState.PENDING
  }
  case object failed extends zio.aws.ec2.model.CapacityReservationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationState =
      software.amazon.awssdk.services.ec2.model.CapacityReservationState.FAILED
  }
}
