package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayPolicyTableId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateTransitGatewayPolicyTableRequest(
    transitGatewayPolicyTableId: TransitGatewayPolicyTableId,
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest = {
    import AssociateTransitGatewayPolicyTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest
      .builder()
      .transitGatewayPolicyTableId(
        TransitGatewayPolicyTableId.unwrap(
          transitGatewayPolicyTableId
        ): java.lang.String
      )
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateTransitGatewayPolicyTableRequest.ReadOnly =
    zio.aws.ec2.model.AssociateTransitGatewayPolicyTableRequest
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayPolicyTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateTransitGatewayPolicyTableRequest =
      zio.aws.ec2.model.AssociateTransitGatewayPolicyTableRequest(
        transitGatewayPolicyTableId,
        transitGatewayAttachmentId
      )
    def transitGatewayPolicyTableId: TransitGatewayPolicyTableId
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayPolicyTableId
        : ZIO[Any, Nothing, TransitGatewayPolicyTableId] =
      ZIO.succeed(transitGatewayPolicyTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest
  ) extends zio.aws.ec2.model.AssociateTransitGatewayPolicyTableRequest.ReadOnly {
    override val transitGatewayPolicyTableId: TransitGatewayPolicyTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayPolicyTableId(impl.transitGatewayPolicyTableId())
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest
  ): zio.aws.ec2.model.AssociateTransitGatewayPolicyTableRequest.ReadOnly =
    new Wrapper(impl)
}
