package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AcceleratorName {
  def unwrap: software.amazon.awssdk.services.ec2.model.AcceleratorName
}
object AcceleratorName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AcceleratorName
  ): zio.aws.ec2.model.AcceleratorName = value match {
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.A100 =>
      val r = a100
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.V100 =>
      val r = v100
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.K80 =>
      val r = k80
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.T4 =>
      val r = t4
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.M60 =>
      val r = m60
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.RADEON_PRO_V520 =>
      val r = `radeon-pro-v520`
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.VU9_P =>
      val r = vu9p
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.INFERENTIA =>
      val r = inferentia
      r
    case software.amazon.awssdk.services.ec2.model.AcceleratorName.K520 =>
      val r = k520
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.UNKNOWN_TO_SDK_VERSION
  }
  case object a100 extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.A100
  }
  case object v100 extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.V100
  }
  case object k80 extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.K80
  }
  case object t4 extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.T4
  }
  case object m60 extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.M60
  }
  case object `radeon-pro-v520` extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.RADEON_PRO_V520
  }
  case object vu9p extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.VU9_P
  }
  case object inferentia extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.INFERENTIA
  }
  case object k520 extends zio.aws.ec2.model.AcceleratorName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AcceleratorName =
      software.amazon.awssdk.services.ec2.model.AcceleratorName.K520
  }
}
