package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class TransitGatewayRouteTable(
    transitGatewayRouteTableId: Optional[String] = Optional.Absent,
    transitGatewayId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayRouteTableState] =
      Optional.Absent,
    defaultAssociationRouteTable: Optional[Boolean] = Optional.Absent,
    defaultPropagationRouteTable: Optional[Boolean] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable = {
    import TransitGatewayRouteTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
      .builder()
      .optionallyWith(
        transitGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.transitGatewayRouteTableId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        defaultAssociationRouteTable.map(value => value: java.lang.Boolean)
      )(_.defaultAssociationRouteTable)
      .optionallyWith(
        defaultPropagationRouteTable.map(value => value: java.lang.Boolean)
      )(_.defaultPropagationRouteTable)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRouteTable.wrap(buildAwsValue())
}
object TransitGatewayRouteTable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRouteTable =
      zio.aws.ec2.model.TransitGatewayRouteTable(
        transitGatewayRouteTableId.map(value => value),
        transitGatewayId.map(value => value),
        state.map(value => value),
        defaultAssociationRouteTable.map(value => value),
        defaultPropagationRouteTable.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayRouteTableId: Optional[String]
    def transitGatewayId: Optional[String]
    def state: Optional[zio.aws.ec2.model.TransitGatewayRouteTableState]
    def defaultAssociationRouteTable: Optional[Boolean]
    def defaultPropagationRouteTable: Optional[Boolean]
    def creationTime: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRouteTableState] =
      AwsError.unwrapOptionField("state", state)
    def getDefaultAssociationRouteTable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "defaultAssociationRouteTable",
        defaultAssociationRouteTable
      )
    def getDefaultPropagationRouteTable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "defaultPropagationRouteTable",
        defaultPropagationRouteTable
      )
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
  ) extends zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly {
    override val transitGatewayRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableId())
        .map(value => value: String)
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTableState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayRouteTableState.wrap(value)
        )
    override val defaultAssociationRouteTable: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultAssociationRouteTable())
        .map(value => value: Boolean)
    override val defaultPropagationRouteTable: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultPropagationRouteTable())
        .map(value => value: Boolean)
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
  ): zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly = new Wrapper(impl)
}
