package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayRouteTableAnnouncementId,
  TransitGatewayAttachmentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPropagation(
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = Optional.Absent,
    transitGatewayRouteTableId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayPropagationState] =
      Optional.Absent,
    transitGatewayRouteTableAnnouncementId: Optional[
      TransitGatewayRouteTableAnnouncementId
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation = {
    import TransitGatewayPropagation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        transitGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.transitGatewayRouteTableId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        transitGatewayRouteTableAnnouncementId.map(value =>
          TransitGatewayRouteTableAnnouncementId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableAnnouncementId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPropagation.wrap(buildAwsValue())
}
object TransitGatewayPropagation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPropagation =
      zio.aws.ec2.model.TransitGatewayPropagation(
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        transitGatewayRouteTableId.map(value => value),
        state.map(value => value),
        transitGatewayRouteTableAnnouncementId.map(value => value)
      )
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def resourceId: Optional[String]
    def resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def transitGatewayRouteTableId: Optional[String]
    def state: Optional[zio.aws.ec2.model.TransitGatewayPropagationState]
    def transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId]
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getTransitGatewayRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayPropagationState] =
      AwsError.unwrapOptionField("state", state)
    def getTransitGatewayRouteTableAnnouncementId
        : ZIO[Any, AwsError, TransitGatewayRouteTableAnnouncementId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableAnnouncementId",
        transitGatewayRouteTableAnnouncementId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
  ) extends zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly {
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
        )
    override val transitGatewayRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableId())
        .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayPropagationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPropagationState.wrap(value)
        )
    override val transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableAnnouncementId())
        .map(value =>
          zio.aws.ec2.model.primitives
            .TransitGatewayRouteTableAnnouncementId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
  ): zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly = new Wrapper(impl)
}
