package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ResourceArn, NetworkInsightsPathId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartNetworkInsightsAnalysisRequest(
    networkInsightsPathId: NetworkInsightsPathId,
    filterInArns: Optional[Iterable[ResourceArn]] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest = {
    import StartNetworkInsightsAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest
      .builder()
      .networkInsightsPathId(
        NetworkInsightsPathId.unwrap(networkInsightsPathId): java.lang.String
      )
      .optionallyWith(
        filterInArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterInArns)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .clientToken(clientToken: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest.ReadOnly =
    zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest.wrap(buildAwsValue())
}
object StartNetworkInsightsAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest =
      zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest(
        networkInsightsPathId,
        filterInArns.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken
      )
    def networkInsightsPathId: NetworkInsightsPathId
    def filterInArns: Optional[List[ResourceArn]]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: String
    def getNetworkInsightsPathId: ZIO[Any, Nothing, NetworkInsightsPathId] =
      ZIO.succeed(networkInsightsPathId)
    def getFilterInArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField("filterInArns", filterInArns)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest
  ) extends zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest.ReadOnly {
    override val networkInsightsPathId: NetworkInsightsPathId =
      zio.aws.ec2.model.primitives
        .NetworkInsightsPathId(impl.networkInsightsPathId())
    override val filterInArns: Optional[List[ResourceArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterInArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ResourceArn(item)
          }.toList
        )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: String = impl.clientToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest
  ): zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
