package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  Integer,
  MillisecondDateTime,
  VolumeId,
  SnapshotId
}
import scala.jdk.CollectionConverters._
final case class SnapshotTierStatus(
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    volumeId: Optional[VolumeId] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.SnapshotState] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    storageTier: Optional[zio.aws.ec2.model.StorageTier] = Optional.Absent,
    lastTieringStartTime: Optional[MillisecondDateTime] = Optional.Absent,
    lastTieringProgress: Optional[Integer] = Optional.Absent,
    lastTieringOperationStatus: Optional[
      zio.aws.ec2.model.TieringOperationStatus
    ] = Optional.Absent,
    lastTieringOperationStatusDetail: Optional[String] = Optional.Absent,
    archivalCompleteTime: Optional[MillisecondDateTime] = Optional.Absent,
    restoreExpiryTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotTierStatus = {
    import SnapshotTierStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotTierStatus
      .builder()
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageTier.map(value => value.unwrap))(_.storageTier)
      .optionallyWith(
        lastTieringStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.lastTieringStartTime)
      .optionallyWith(
        lastTieringProgress.map(value => value: java.lang.Integer)
      )(_.lastTieringProgress)
      .optionallyWith(lastTieringOperationStatus.map(value => value.unwrap))(
        _.lastTieringOperationStatus
      )
      .optionallyWith(
        lastTieringOperationStatusDetail.map(value => value: java.lang.String)
      )(_.lastTieringOperationStatusDetail)
      .optionallyWith(
        archivalCompleteTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.archivalCompleteTime)
      .optionallyWith(
        restoreExpiryTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.restoreExpiryTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotTierStatus.ReadOnly =
    zio.aws.ec2.model.SnapshotTierStatus.wrap(buildAwsValue())
}
object SnapshotTierStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotTierStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotTierStatus =
      zio.aws.ec2.model.SnapshotTierStatus(
        snapshotId.map(value => value),
        volumeId.map(value => value),
        status.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageTier.map(value => value),
        lastTieringStartTime.map(value => value),
        lastTieringProgress.map(value => value),
        lastTieringOperationStatus.map(value => value),
        lastTieringOperationStatusDetail.map(value => value),
        archivalCompleteTime.map(value => value),
        restoreExpiryTime.map(value => value)
      )
    def snapshotId: Optional[SnapshotId]
    def volumeId: Optional[VolumeId]
    def status: Optional[zio.aws.ec2.model.SnapshotState]
    def ownerId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def storageTier: Optional[zio.aws.ec2.model.StorageTier]
    def lastTieringStartTime: Optional[MillisecondDateTime]
    def lastTieringProgress: Optional[Integer]
    def lastTieringOperationStatus
        : Optional[zio.aws.ec2.model.TieringOperationStatus]
    def lastTieringOperationStatusDetail: Optional[String]
    def archivalCompleteTime: Optional[MillisecondDateTime]
    def restoreExpiryTime: Optional[MillisecondDateTime]
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotState] =
      AwsError.unwrapOptionField("status", status)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageTier: ZIO[Any, AwsError, zio.aws.ec2.model.StorageTier] =
      AwsError.unwrapOptionField("storageTier", storageTier)
    def getLastTieringStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("lastTieringStartTime", lastTieringStartTime)
    def getLastTieringProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("lastTieringProgress", lastTieringProgress)
    def getLastTieringOperationStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.TieringOperationStatus] =
      AwsError.unwrapOptionField(
        "lastTieringOperationStatus",
        lastTieringOperationStatus
      )
    def getLastTieringOperationStatusDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "lastTieringOperationStatusDetail",
        lastTieringOperationStatusDetail
      )
    def getArchivalCompleteTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("archivalCompleteTime", archivalCompleteTime)
    def getRestoreExpiryTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("restoreExpiryTime", restoreExpiryTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotTierStatus
  ) extends zio.aws.ec2.model.SnapshotTierStatus.ReadOnly {
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeId: Optional[VolumeId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => zio.aws.ec2.model.primitives.VolumeId(value))
    override val status: Optional[zio.aws.ec2.model.SnapshotState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.SnapshotState.wrap(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val storageTier: Optional[zio.aws.ec2.model.StorageTier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageTier())
        .map(value => zio.aws.ec2.model.StorageTier.wrap(value))
    override val lastTieringStartTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastTieringStartTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val lastTieringProgress: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.lastTieringProgress())
      .map(value => value: Integer)
    override val lastTieringOperationStatus
        : Optional[zio.aws.ec2.model.TieringOperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastTieringOperationStatus())
        .map(value => zio.aws.ec2.model.TieringOperationStatus.wrap(value))
    override val lastTieringOperationStatusDetail: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastTieringOperationStatusDetail())
        .map(value => value: String)
    override val archivalCompleteTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.archivalCompleteTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val restoreExpiryTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreExpiryTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotTierStatus
  ): zio.aws.ec2.model.SnapshotTierStatus.ReadOnly = new Wrapper(impl)
}
