package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResetImageAttributeRequest(
    attribute: zio.aws.ec2.model.ResetImageAttributeName,
    imageId: ImageId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest = {
    import ResetImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ResetImageAttributeRequest.wrap(buildAwsValue())
}
object ResetImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetImageAttributeRequest =
      zio.aws.ec2.model.ResetImageAttributeRequest(attribute, imageId)
    def attribute: zio.aws.ec2.model.ResetImageAttributeName
    def imageId: ImageId
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.ResetImageAttributeName] =
      ZIO.succeed(attribute)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest
  ) extends zio.aws.ec2.model.ResetImageAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.ResetImageAttributeName =
      zio.aws.ec2.model.ResetImageAttributeName.wrap(impl.attribute())
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest
  ): zio.aws.ec2.model.ResetImageAttributeRequest.ReadOnly = new Wrapper(impl)
}
