package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IamInstanceProfileAssociationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReplaceIamInstanceProfileAssociationRequest(
    iamInstanceProfile: zio.aws.ec2.model.IamInstanceProfileSpecification,
    associationId: IamInstanceProfileAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest = {
    import ReplaceIamInstanceProfileAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest
      .builder()
      .iamInstanceProfile(iamInstanceProfile.buildAwsValue())
      .associationId(
        IamInstanceProfileAssociationId.unwrap(associationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest
      .wrap(buildAwsValue())
}
object ReplaceIamInstanceProfileAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest =
      zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest(
        iamInstanceProfile.asEditable,
        associationId
      )
    def iamInstanceProfile
        : zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    def associationId: IamInstanceProfileAssociationId
    def getIamInstanceProfile: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = ZIO.succeed(iamInstanceProfile)
    def getAssociationId: ZIO[Any, Nothing, IamInstanceProfileAssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest
  ) extends zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest.ReadOnly {
    override val iamInstanceProfile
        : zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly =
      zio.aws.ec2.model.IamInstanceProfileSpecification
        .wrap(impl.iamInstanceProfile())
    override val associationId: IamInstanceProfileAssociationId =
      zio.aws.ec2.model.primitives
        .IamInstanceProfileAssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest
  ): zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
