package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PtrUpdateStatus(
    value: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PtrUpdateStatus = {
    import PtrUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PtrUpdateStatus.ReadOnly =
    zio.aws.ec2.model.PtrUpdateStatus.wrap(buildAwsValue())
}
object PtrUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PtrUpdateStatus =
      zio.aws.ec2.model.PtrUpdateStatus(
        value.map(value => value),
        status.map(value => value),
        reason.map(value => value)
      )
    def value: Optional[String]
    def status: Optional[String]
    def reason: Optional[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
  ) extends zio.aws.ec2.model.PtrUpdateStatus.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PtrUpdateStatus
  ): zio.aws.ec2.model.PtrUpdateStatus.ReadOnly = new Wrapper(impl)
}
