package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PriceScheduleSpecification(
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    price: Optional[Double] = Optional.Absent,
    term: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification = {
    import PriceScheduleSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification
      .builder()
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(price.map(value => value: java.lang.Double))(_.price)
      .optionallyWith(term.map(value => value: java.lang.Long))(_.term)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PriceScheduleSpecification.ReadOnly =
    zio.aws.ec2.model.PriceScheduleSpecification.wrap(buildAwsValue())
}
object PriceScheduleSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PriceScheduleSpecification =
      zio.aws.ec2.model.PriceScheduleSpecification(
        currencyCode.map(value => value),
        price.map(value => value),
        term.map(value => value)
      )
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def price: Optional[Double]
    def term: Optional[Long]
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("price", price)
    def getTerm: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("term", term)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification
  ) extends zio.aws.ec2.model.PriceScheduleSpecification.ReadOnly {
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val price: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.price())
      .map(value => value: Double)
    override val term: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.term())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification
  ): zio.aws.ec2.model.PriceScheduleSpecification.ReadOnly = new Wrapper(impl)
}
