package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlacementGroupInfo(
    supportedStrategies: Optional[
      Iterable[zio.aws.ec2.model.PlacementGroupStrategy]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PlacementGroupInfo = {
    import PlacementGroupInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PlacementGroupInfo
      .builder()
      .optionallyWith(
        supportedStrategies.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedStrategiesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PlacementGroupInfo.ReadOnly =
    zio.aws.ec2.model.PlacementGroupInfo.wrap(buildAwsValue())
}
object PlacementGroupInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PlacementGroupInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PlacementGroupInfo = zio.aws.ec2.model
      .PlacementGroupInfo(supportedStrategies.map(value => value))
    def supportedStrategies
        : Optional[List[zio.aws.ec2.model.PlacementGroupStrategy]]
    def getSupportedStrategies
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PlacementGroupStrategy]] =
      AwsError.unwrapOptionField("supportedStrategies", supportedStrategies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PlacementGroupInfo
  ) extends zio.aws.ec2.model.PlacementGroupInfo.ReadOnly {
    override val supportedStrategies
        : Optional[List[zio.aws.ec2.model.PlacementGroupStrategy]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedStrategies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PlacementGroupStrategy.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PlacementGroupInfo
  ): zio.aws.ec2.model.PlacementGroupInfo.ReadOnly = new Wrapper(impl)
}
