package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyReservedInstancesResponse(
    reservedInstancesModificationId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse = {
    import ModifyReservedInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse
      .builder()
      .optionallyWith(
        reservedInstancesModificationId.map(value => value: java.lang.String)
      )(_.reservedInstancesModificationId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly =
    zio.aws.ec2.model.ModifyReservedInstancesResponse.wrap(buildAwsValue())
}
object ModifyReservedInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyReservedInstancesResponse =
      zio.aws.ec2.model.ModifyReservedInstancesResponse(
        reservedInstancesModificationId.map(value => value)
      )
    def reservedInstancesModificationId: Optional[String]
    def getReservedInstancesModificationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedInstancesModificationId",
        reservedInstancesModificationId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse
  ) extends zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly {
    override val reservedInstancesModificationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesModificationId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse
  ): zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
