package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolAllocationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamPoolAllocation(
    cidr: Optional[String] = Optional.Absent,
    ipamPoolAllocationId: Optional[IpamPoolAllocationId] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[zio.aws.ec2.model.IpamPoolAllocationResourceType] =
      Optional.Absent,
    resourceRegion: Optional[String] = Optional.Absent,
    resourceOwner: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamPoolAllocation = {
    import IpamPoolAllocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(
        ipamPoolAllocationId.map(value =>
          IpamPoolAllocationId.unwrap(value): java.lang.String
        )
      )(_.ipamPoolAllocationId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceRegion.map(value => value: java.lang.String))(
        _.resourceRegion
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamPoolAllocation.ReadOnly =
    zio.aws.ec2.model.IpamPoolAllocation.wrap(buildAwsValue())
}
object IpamPoolAllocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamPoolAllocation =
      zio.aws.ec2.model.IpamPoolAllocation(
        cidr.map(value => value),
        ipamPoolAllocationId.map(value => value),
        description.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceRegion.map(value => value),
        resourceOwner.map(value => value)
      )
    def cidr: Optional[String]
    def ipamPoolAllocationId: Optional[IpamPoolAllocationId]
    def description: Optional[String]
    def resourceId: Optional[String]
    def resourceType: Optional[zio.aws.ec2.model.IpamPoolAllocationResourceType]
    def resourceRegion: Optional[String]
    def resourceOwner: Optional[String]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getIpamPoolAllocationId: ZIO[Any, AwsError, IpamPoolAllocationId] =
      AwsError.unwrapOptionField("ipamPoolAllocationId", ipamPoolAllocationId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAllocationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
  ) extends zio.aws.ec2.model.IpamPoolAllocation.ReadOnly {
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val ipamPoolAllocationId: Optional[IpamPoolAllocationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamPoolAllocationId())
        .map(value => zio.aws.ec2.model.primitives.IpamPoolAllocationId(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.IpamPoolAllocationResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.IpamPoolAllocationResourceType.wrap(value)
        )
    override val resourceRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRegion())
      .map(value => value: String)
    override val resourceOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwner())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolAllocation
  ): zio.aws.ec2.model.IpamPoolAllocation.ReadOnly = new Wrapper(impl)
}
