package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamOverlapStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamOverlapStatus
}
object IpamOverlapStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamOverlapStatus
  ): zio.aws.ec2.model.IpamOverlapStatus = value match {
    case software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.OVERLAPPING =>
      val r = overlapping
      r
    case software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.NONOVERLAPPING =>
      val r = nonoverlapping
      r
    case software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.IGNORED =>
      val r = ignored
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.IpamOverlapStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamOverlapStatus =
      software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object overlapping extends zio.aws.ec2.model.IpamOverlapStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamOverlapStatus =
      software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.OVERLAPPING
  }
  case object nonoverlapping extends zio.aws.ec2.model.IpamOverlapStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamOverlapStatus =
      software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.NONOVERLAPPING
  }
  case object ignored extends zio.aws.ec2.model.IpamOverlapStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamOverlapStatus =
      software.amazon.awssdk.services.ec2.model.IpamOverlapStatus.IGNORED
  }
}
