package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageDiskContainer(
    description: Optional[String] = Optional.Absent,
    deviceName: Optional[String] = Optional.Absent,
    format: Optional[String] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    url: Optional[String] = Optional.Absent,
    userBucket: Optional[zio.aws.ec2.model.UserBucket] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImageDiskContainer = {
    import ImageDiskContainer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImageDiskContainer
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(userBucket.map(value => value.buildAwsValue()))(
        _.userBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImageDiskContainer.ReadOnly =
    zio.aws.ec2.model.ImageDiskContainer.wrap(buildAwsValue())
}
object ImageDiskContainer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImageDiskContainer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImageDiskContainer =
      zio.aws.ec2.model.ImageDiskContainer(
        description.map(value => value),
        deviceName.map(value => value),
        format.map(value => value),
        snapshotId.map(value => value),
        url.map(value => value),
        userBucket.map(value => value.asEditable)
      )
    def description: Optional[String]
    def deviceName: Optional[String]
    def format: Optional[String]
    def snapshotId: Optional[SnapshotId]
    def url: Optional[String]
    def userBucket: Optional[zio.aws.ec2.model.UserBucket.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
    def getUserBucket
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserBucket.ReadOnly] =
      AwsError.unwrapOptionField("userBucket", userBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImageDiskContainer
  ) extends zio.aws.ec2.model.ImageDiskContainer.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val deviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: String)
    override val format: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => value: String)
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
    override val userBucket: Optional[zio.aws.ec2.model.UserBucket.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userBucket())
        .map(value => zio.aws.ec2.model.UserBucket.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImageDiskContainer
  ): zio.aws.ec2.model.ImageDiskContainer.ReadOnly = new Wrapper(impl)
}
