package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayPrefixListReferencesResponse(
    transitGatewayPrefixListReferences: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayPrefixListReference]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse = {
    import GetTransitGatewayPrefixListReferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
      .builder()
      .optionallyWith(
        transitGatewayPrefixListReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayPrefixListReferences)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayPrefixListReferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse =
      zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse(
        transitGatewayPrefixListReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayPrefixListReferences: Optional[
      List[zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getTransitGatewayPrefixListReferences: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayPrefixListReferences",
      transitGatewayPrefixListReferences
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly {
    override val transitGatewayPrefixListReferences: Optional[
      List[zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPrefixListReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayPrefixListReference.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
  ): zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly =
    new Wrapper(impl)
}
