package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIpamAddressHistoryResponse(
    historyRecords: Optional[
      Iterable[zio.aws.ec2.model.IpamAddressHistoryRecord]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse = {
    import GetIpamAddressHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse
      .builder()
      .optionallyWith(
        historyRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.historyRecords)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly =
    zio.aws.ec2.model.GetIpamAddressHistoryResponse.wrap(buildAwsValue())
}
object GetIpamAddressHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamAddressHistoryResponse =
      zio.aws.ec2.model.GetIpamAddressHistoryResponse(
        historyRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def historyRecords
        : Optional[List[zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getHistoryRecords: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("historyRecords", historyRecords)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse
  ) extends zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly {
    override val historyRecords
        : Optional[List[zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.historyRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamAddressHistoryRecord.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse
  ): zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
