package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class EnableFastSnapshotRestoreSuccessItem(
    snapshotId: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.FastSnapshotRestoreStateCode] =
      Optional.Absent,
    stateTransitionReason: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    ownerAlias: Optional[String] = Optional.Absent,
    enablingTime: Optional[MillisecondDateTime] = Optional.Absent,
    optimizingTime: Optional[MillisecondDateTime] = Optional.Absent,
    enabledTime: Optional[MillisecondDateTime] = Optional.Absent,
    disablingTime: Optional[MillisecondDateTime] = Optional.Absent,
    disabledTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem = {
    import EnableFastSnapshotRestoreSuccessItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateTransitionReason.map(value => value: java.lang.String)
      )(_.stateTransitionReason)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(ownerAlias.map(value => value: java.lang.String))(
        _.ownerAlias
      )
      .optionallyWith(
        enablingTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.enablingTime)
      .optionallyWith(
        optimizingTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.optimizingTime)
      .optionallyWith(
        enabledTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.enabledTime)
      .optionallyWith(
        disablingTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.disablingTime)
      .optionallyWith(
        disabledTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.disabledTime)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly =
    zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.wrap(buildAwsValue())
}
object EnableFastSnapshotRestoreSuccessItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem =
      zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem(
        snapshotId.map(value => value),
        availabilityZone.map(value => value),
        state.map(value => value),
        stateTransitionReason.map(value => value),
        ownerId.map(value => value),
        ownerAlias.map(value => value),
        enablingTime.map(value => value),
        optimizingTime.map(value => value),
        enabledTime.map(value => value),
        disablingTime.map(value => value),
        disabledTime.map(value => value)
      )
    def snapshotId: Optional[String]
    def availabilityZone: Optional[String]
    def state: Optional[zio.aws.ec2.model.FastSnapshotRestoreStateCode]
    def stateTransitionReason: Optional[String]
    def ownerId: Optional[String]
    def ownerAlias: Optional[String]
    def enablingTime: Optional[MillisecondDateTime]
    def optimizingTime: Optional[MillisecondDateTime]
    def enabledTime: Optional[MillisecondDateTime]
    def disablingTime: Optional[MillisecondDateTime]
    def disabledTime: Optional[MillisecondDateTime]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FastSnapshotRestoreStateCode] =
      AwsError.unwrapOptionField("state", state)
    def getStateTransitionReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateTransitionReason", stateTransitionReason)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
    def getEnablingTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("enablingTime", enablingTime)
    def getOptimizingTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("optimizingTime", optimizingTime)
    def getEnabledTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("enabledTime", enabledTime)
    def getDisablingTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("disablingTime", disablingTime)
    def getDisabledTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("disabledTime", disabledTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
  ) extends zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly {
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.FastSnapshotRestoreStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.FastSnapshotRestoreStateCode.wrap(value)
        )
    override val stateTransitionReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateTransitionReason())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val ownerAlias: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAlias())
      .map(value => value: String)
    override val enablingTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablingTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val optimizingTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizingTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val enabledTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val disablingTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disablingTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val disabledTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disabledTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem
  ): zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly =
    new Wrapper(impl)
}
