package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DynamicRoutingValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.DynamicRoutingValue
}
object DynamicRoutingValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DynamicRoutingValue
  ): zio.aws.ec2.model.DynamicRoutingValue = value match {
    case software.amazon.awssdk.services.ec2.model.DynamicRoutingValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DynamicRoutingValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.DynamicRoutingValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DynamicRoutingValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DynamicRoutingValue =
      software.amazon.awssdk.services.ec2.model.DynamicRoutingValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.DynamicRoutingValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DynamicRoutingValue =
      software.amazon.awssdk.services.ec2.model.DynamicRoutingValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.DynamicRoutingValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DynamicRoutingValue =
      software.amazon.awssdk.services.ec2.model.DynamicRoutingValue.DISABLE
  }
}
