package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePrefixListsResponse(
    nextToken: Optional[String] = Optional.Absent,
    prefixLists: Optional[Iterable[zio.aws.ec2.model.PrefixList]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse = {
    import DescribePrefixListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        prefixLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixLists)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly =
    zio.aws.ec2.model.DescribePrefixListsResponse.wrap(buildAwsValue())
}
object DescribePrefixListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrefixListsResponse =
      zio.aws.ec2.model.DescribePrefixListsResponse(
        nextToken.map(value => value),
        prefixLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def prefixLists: Optional[List[zio.aws.ec2.model.PrefixList.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefixLists
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PrefixList.ReadOnly]] =
      AwsError.unwrapOptionField("prefixLists", prefixLists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
  ) extends zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val prefixLists
        : Optional[List[zio.aws.ec2.model.PrefixList.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PrefixList.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse
  ): zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly = new Wrapper(impl)
}
